using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    struct Mast
    {
        public long x, h;
        public int id;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] X = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] H = Console.ReadLine().Split().Select(long.Parse).ToArray();

        Mast[] a = new Mast[n];
        for (int i = 0; i < n; i++)
            a[i] = new Mast { x = X[i], h = H[i], id = i };

        Array.Sort(a, (p, q) => p.x.CompareTo(q.x));

        const long INF = (long)1e18;
        long[] ans = Enumerable.Repeat(INF, n).ToArray();

        Solve(a, ans, true);   // x + h
        Solve(a, ans, false);  // x - h

        for (int i = 0; i < n; i++)
        {
            if (ans[i] == INF) Console.WriteLine(-1);
            else Console.WriteLine(ans[i]);
        }
    }

    static void Solve(Mast[] a, long[] ans, bool plus)
    {
        int n = a.Length;
        Stack<int> st = new Stack<int>();

        for (int i = 0; i < n; i++)
        {
            long val = plus ? a[i].x + a[i].h : a[i].x - a[i].h;

            while (st.Count > 0)
            {
                int j = st.Peek();
                long valj = plus ? a[j].x + a[j].h : a[j].x - a[j].h;

                if (valj >= val)
                {
                    ans[a[i].id] = Math.Min(ans[a[i].id],
                        Math.Abs(a[i].x - a[j].x));
                    break;
                }
                st.Pop();
            }

            st.Push(i);
        }

        st.Clear();

        for (int i = n - 1; i >= 0; i--)
        {
            long val = plus ? a[i].x + a[i].h : a[i].x - a[i].h;

            while (st.Count > 0)
            {
                int j = st.Peek();
                long valj = plus ? a[j].x + a[j].h : a[j].x - a[j].h;

                if (valj >= val)
                {
                    ans[a[i].id] = Math.Min(ans[a[i].id],
                        Math.Abs(a[i].x - a[j].x));
                    break;
                }
                st.Pop();
            }

            st.Push(i);
        }
    }
}